<?php

/*
 * This file is part of the Symfony package.
 *
 * (c) Fabien Potencier <fabien@symfony.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */
namespace MailPoetVendor\Symfony\Component\Validator\Constraints;

if (!defined('ABSPATH')) exit;


use MailPoetVendor\Symfony\Component\Validator\Constraint;
/**
 * @Annotation
 * @Target({"PROPERTY", "METHOD", "ANNOTATION"})
 *
 * @author Bernhard Schussek <bschussek@gmail.com>
 */
class Email extends \MailPoetVendor\Symfony\Component\Validator\Constraint
{
    const INVALID_FORMAT_ERROR = 'bd79c0ab-ddba-46cc-a703-a7a4b08de310';
    const MX_CHECK_FAILED_ERROR = 'bf447c1c-0266-4e10-9c6c-573df282e413';
    const HOST_CHECK_FAILED_ERROR = '7da53a8b-56f3-4288-bb3e-ee9ede4ef9a1';
    protected static $errorNames = [self::INVALID_FORMAT_ERROR => 'STRICT_CHECK_FAILED_ERROR', self::MX_CHECK_FAILED_ERROR => 'MX_CHECK_FAILED_ERROR', self::HOST_CHECK_FAILED_ERROR => 'HOST_CHECK_FAILED_ERROR'];
    public $message = 'This value is not a valid email address.';
    public $checkMX = \false;
    public $checkHost = \false;
    public $strict;
}
