<?php

/*
 * This file is part of the Symfony package.
 *
 * (c) Fabien Potencier <fabien@symfony.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */
namespace MailPoetVendor\Symfony\Component\DependencyInjection\Loader\Configurator\Traits;

if (!defined('ABSPATH')) exit;


/**
 * @method $this class(string $class)
 */
trait ClassTrait
{
    /**
     * Sets the service class.
     *
     * @param string $class The service class
     *
     * @return $this
     */
    protected final function setClass($class)
    {
        $this->definition->setClass($class);
        return $this;
    }
}
